<?php
/**
 * Plugin Name: Harsit Trade Link Payment Gateway
 * Description: Custom WooCommerce payment gateway for Harsit Trade Link API.
 * Version: 1.1.0
 * Author: Harsit Kushmi
 * Author URI: https://app.harsittradelink.com.np/
 * License: GPL2
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'plugins_loaded', 'harsit_trade_link_init_gateway', 11 );

function harsit_trade_link_init_gateway() {
    if ( ! class_exists( 'WC_Payment_Gateway' ) ) return;

    require_once plugin_dir_path( __FILE__ ) . 'includes/class-harsit-api-handler.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-harsit-trade-link-payment-gateway.php';

    add_filter( 'woocommerce_payment_gateways', function( $methods ) {
        $methods[] = 'Harsit_Trade_Link_Payment_Gateway';
        return $methods;
    });
}


// ✅ Styling for payment option
add_action( 'wp_head', function() {
    if ( is_checkout() ) {
        echo '<style>
            .payment_method_harsit_trade_link img {
                max-height: 32px !important;
                width: auto !important;
            }
        </style>';
    }
});

// ✅ Fix: Define the missing callback function
function change_payment_complete_order_status( $order_id ) {
    if ( ! $order_id ) return;

    $order = wc_get_order( $order_id );
    if ( ! $order || ! is_a( $order, 'WC_Order' ) ) return;

    // Optional: Log or act on successful payment completion
    $order->add_order_note( 'Hook: change_payment_complete_order_status() called after payment complete.' );
}

// ✅ Hook into WooCommerce order status transitions
add_action( 'woocommerce_payment_complete_order_status_processing', 'change_payment_complete_order_status' );
add_action( 'woocommerce_payment_complete_order_status_completed', 'change_payment_complete_order_status' );