<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Harsit_API_Handler {
    private $base_url;

    public function __construct( $mode = 'test' ) {
        $this->base_url = ( $mode === 'live' )
            ? 'https://merchant.harsittradelink.com.np'
            : 'https://uatmerchant.harsittradelink.com.np';
    }

    public function initialize_payment( $amount, $transaction_uuid, $return_url, $secret_key ) {
        $url = $this->base_url . '/api/v1/payment/initialize';
        $data = [
            'amount'           => $amount,
            'transaction_uuid' => $transaction_uuid,
            'return_url'       => $return_url,
            'secret_key'       => $secret_key,
        ];
        return $this->make_request( $url, $data );
    }

    public function check_payment_status( $txn_id, $secret_key ) {
        $url = $this->base_url . '/api/v1/payment/check';
        $data = [
            'txnId'      => $txn_id,
            'secret_key' => $secret_key,
        ];
        return $this->make_request( $url, $data );
    }

    private function make_request( $url, $data ) {
        $response = wp_remote_post( $url, [
            'method'  => 'POST',
            'headers' => ['Content-Type' => 'application/json'],
            'body'    => wp_json_encode( $data ),
            'timeout' => 30,
        ]);

        if ( is_wp_error( $response ) ) {
            return ['success' => false, 'message' => 'Failed to connect to payment server.'];
        }

        return json_decode( wp_remote_retrieve_body( $response ), true );
    }
}
